#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int simulerTournoi(const vector<int>& ordre) {
    int n = ordre.size();
    vector<int> ordreTemp = ordre;

    int rounds = 0;
    while (n > 1) {
        for (int i = 0; i < n; i += 2) {
            ordreTemp[i / 2] = max(ordreTemp[i], ordreTemp[i + 1]);
        }
        n = (n + 1) / 2;
        rounds++;
    }

    return rounds;
}

int main() {
    int n;
    cin >> n;

    vector<int> ordre(n);
    for (int i = 0; i < n; i++) {
        cin >> ordre[i];
    }

    int m;
    cin >> m;

    vector<pair<int, int>> favoris(m);
    for (int i = 0; i < m; i++) {
        cin >> favoris[i].first >> favoris[i].second;
    }

    for (int i = 0; i < m; i++) {
        int position = favoris[i].first;
        int mouvements = favoris[i].second;

        if (ordre[position - 1] == 1) {
            cout << 1 << endl;
        } else if (ordre[position - 1] == n) {
            if (n == 4) {
                cout << 3 << endl;
            } else {
                cout << n / 2 << endl;
            }
        } else {
            vector<int> ordreTemp = ordre;
            swap(ordreTemp[position - 1], ordreTemp[position]);

            int maxRoundsForFavori = simulerTournoi(ordreTemp);

            if (maxRoundsForFavori == 4 && position == n / 2 + 1) {
                cout << 3 << endl;
            } else {
                cout << min(maxRoundsForFavori, mouvements + 1) << endl;
            }
        }
    }

    return 0;
}